﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;
using System.Threading;
using System.Collections;

namespace DMX_Revolution
{
    public partial class DMX_Revolution : Form
    {
        public Haupt main;

        //eigene Portklasse wird gestartet.
        Port port;

        //Exit EventArgs
        public event EventHandler exit;

        public delegate void StroboValues(int ms, int times);
        StroboValues strobval;

        //Public Stroboskop-Variaglen
        public int ms;
        public int times;

        //Settings-Forms wird deklariert und instanziert.
        Settings setup = new Settings();

        //Starten der des Zufallszahlengenerators für die zufällige generierung von Farbwerten.
        Random random = new Random();

        public DMX_Revolution()
        {
            InitializeComponent();
            main = new Haupt();

            //Erst wird das Setup ausgeführt und ein spezieller EventHandler
            
            setup.exit += new EventHandler(setup_exit);
            setup.SetChange += new EventHandler<SetChangeEventArgs>(setup_SetChange);
            while (!main.Okay)
            {
                if (main.Port == "exit")
                {
                    this.Close();
                    main.Okay = false;
                    break;

                }
                else
                {
                    setup.ShowDialog();
                }
            }

            //Das Hauptprogramm wird erst ausgeführt, wenn das Setup erfolgreich durchgeführt wurde.
            //Der Port wird nun 'ordentlich' instanziert.
            if (main.Port.StartsWith("COM"))
            {
                port = new Port(main.Port);
            }
            else
            {
                port = new Port("COM1");
            }

            //Portverbindungssitzung wird gestartet.

            try
            {
                port.start();
            }
            catch
            {
                MessageBox.Show("Kein gültiger COM-Port gefunden!", "Fehler", MessageBoxButtons.OK, MessageBoxIcon.Error);
                Close();
            }

            if (main.Port == "exit")
            {
            }

            //Interfacetyp wird abgefragt.
            //label_type.Text = port.get("I");

        }

        void setup_exit(object sender, EventArgs e)
        {
            setup.Close();
            Application.ExitThread();
            this.Close();
        }

        void setup_SetChange(object sender, SetChangeEventArgs e)
        {
            main.Okay = true;
            main.Port = e.Portname;
            label1.Text = main.Port;
        }


        //Die zentrale Sendefunktion die dem Port geänderte Farbwerte sendet. In der Port-Klasse werden diese dann weiter zu regulären Befehlen weiter verarbeitet.

        public void colsend(Color col)
        {
            int alpha, red, green, blue;
            alpha = col.A;
            red = col.R;
            green = col.G;
            blue = col.B;
            c001.Text = red.ToString();
            c002.Text = green.ToString();
            c003.Text = blue.ToString();
            c005.Text = alpha.ToString();
            port.send(1,red);
            port.send(2, green);
            port.send(3, green);
            port.send(5, alpha);
        }

        //void setup_SetChange(object sender, EventArgs e)
        //{
        //    main.Port = (sender as Settings).Port;
        //}


        //Startet erneut das Setup

        private void button3_Click(object sender, EventArgs e)
        {
            Settings setup = new Settings();
            setup.Show();
        }
        public void transfer()
        {
            Port transfer = new Port(main.Port);
        }


        //Startet das Fenster für die Manuelle Farbsteuerung und der Stroboskopfunktion.

        private void button2_Click(object sender, EventArgs e)
        {
            ColorControl colcont = new ColorControl();
            colcont.Control += new EventHandler<Control>(colcont_Control);
            colcont.BwStrobo += new EventHandler<Strobo>(colcont_BwStrobo);
            colcont.ColorStrobo += new EventHandler<Strobo>(colcont_ColorStrobo);
            colcont.Show();
        }

        //Der Event-Empfänger für die Color-Strobo Argumete.
        void colcont_ColorStrobo(object sender, Strobo e)
        {
            ms = e.Ms;
            times = e.Times;
            Thread COLStrob = new Thread(colstrobo);
            COLStrob.Start();
        }

        //Der Event-Empfänger für die Schwarz/Weiss-Strobo Argumente.
        void colcont_BwStrobo(object sender, Strobo e)
        {
            ms = e.Ms;
            times = e.Times;
            Thread BWstrob = new Thread(bwstobo);
            BWstrob.Start();
        }
        void colcont_Control(object sender, Control e)
        {
            port.send(e.Channel, e.Value);
            switch (e.Channel.ToString())
            {
                case "1":
                    c001.Text = e.Value.ToString();
                    break;
                case "2":
                    c002.Text = e.Value.ToString();
                    break;
                case "3":
                    c003.Text = e.Value.ToString();
                    break;
                case "4":
                    c004.Text = e.Value.ToString();
                    break;
                case "5":
                    c005.Text = e.Value.ToString();
                    break;
            }
        }

        //Die Interface Reset-Funktion. Setzt alle Kanäle auf 1 (Null) und Resettet die Verbindung.
        private void button4_Click(object sender, EventArgs e)
        {
            port.send(1, 1);
            port.send(2, 1);
            port.send(3, 1);
            port.send(4, 1);
            port.send(5, 1);
            port.stop();
            port.start();
        }

        //Hier wir das Webcam-Ambilight Fenster Instanziert und gestartet.
        private void button1_Click(object sender, EventArgs e)
        {
            TestAvicap32.Form1 DeinFenster = new TestAvicap32.Form1();
            DeinFenster.Show();
            DeinFenster.colevt += new EventHandler<TestAvicap32.ColorEvent>(DeinFenster_colevt);
        }


        // Dieser Event-Empfänger nimmt die Farbwerte von der Amilight/Webcam Funktion entgegen.
        void DeinFenster_colevt(object sender, TestAvicap32.ColorEvent e)
        {
            port.send(1, e.Color.R);
            port.send(2, e.Color.G);
            port.send(3, e.Color.B);
            port.send(5, e.Color.A);
            c001.Text = e.Color.R.ToString();
            c002.Text = e.Color.G.ToString();
            c003.Text = e.Color.B.ToString();
            c005.Text = e.Color.A.ToString();
        }

        //Die Definition des BW-Strobo funktion
        public void bwstobo()
        {
            if (ms < 10)
                ms = 10;
            
            for (int i = 0; i <times ; i++)
            {
                port.send(1, 255);
                port.send(2, 255);
                port.send(3, 255);
                port.send(4, 255);
                port.send(5, 255);
                /*
                c001.Text = "255";
                c002.Text = "255";
                c003.Text = "255";
                c004.Text = "255";
                c005.Text = "255";
                 * */
                Thread.Sleep(10);
                port.send(1, 1);
                port.send(2, 1);
                port.send(3, 1);
                port.send(4, 1);
                port.send(5, 1);
                /*
                c001.Text = "1";
                c002.Text = "1";
                c003.Text = "1";
                c004.Text = "1";
                c005.Text = "1";
                 * */
                Thread.Sleep(ms-10);

            }
        }

        //Die Definition des BW-Strobo funktion
        public void colstrobo()
        {
            if (ms < 10)
                ms = 10;
            port.send(5, 255);
            c005.Text = "255";

            for (int i = 0; i < times; i++)
            {
                int rand;
                rand = random.Next(1, 4);
                port.send(rand, 255);
                switch (rand)
                {
                    case 1:
                        c001.Text = "255";
                        break;
                    case 2:
                        c002.Text = "255";
                        break;
                    case 3:
                        c003.Text = "255";
                        break;
                    case 4:
                        c004.Text = "255";
                        break;
                }
                Thread.Sleep(10);
                port.send(rand, 1);
                switch (rand)
                {
                    case 1:
                        c001.Text = "1";
                        break;
                    case 2:
                        c002.Text = "1";
                        break;
                    case 3:
                        c003.Text = "1";
                        break;
                    case 4:
                        c004.Text = "1";
                        break;
                }
                Thread.Sleep(ms-10);
            }
            port.send(5, 1);
            c005.Text = "1";
        }

        //Eine implementierte 'Time-Section' diese wurde jedoch nicht weiter benutzt.
        private void button3_Click_1(object sender, EventArgs e)
        {
            Time time = new Time();
            time.Show();
            time.ColChange += new EventHandler<ColorChange>(time_ColChange);
            time.CCStop += new EventHandler(time_CCStop);
        }

        //Manuelle Abbruchmöglichkeit für dden Strobo-Thread.
        void time_CCStop(object sender, EventArgs e)
        {
            port.send(1, 1);
            port.send(2, 1);
            port.send(3, 1);
            port.send(5, 255);

        }

        //Überbleibsel von der 'Time-Section'.
        //Da dies keine defizite aufwiest wurde sie drinnen gelassen. Ist aber für die momentane Bedeutung nciht von bedeutung.
        public ArrayList cols = new ArrayList();

        void time_ColChange(object sender, ColorChange e)
        {
            one = e.One;
            two = e.Two;
            three = e.Three;
            four = e.Four;
            five = e.Five;
            duration = e.Duration;
            smooth = e.Smooth;
            if (one.R != 0 || one.G != 0 || one.B != 0)
                cols.Add(one);
            if (two.R != 0 || two.G != 0 || two.B != 0)
                cols.Add(two);
            if (three.R != 0 || three.G != 0 || three.B != 0)
                cols.Add(three);
            if (four.R != 0 || four.G != 0 || four.B != 0)
                cols.Add(four);
            if (five.R != 0 || five.G != 0 || five.B != 0)
                cols.Add(five);
            Thread rainbow = new Thread(colorchange);
            rainbow.Start();
        }
        Color one, two, three, four, five;
        int duration, smooth;
        public void colorchange()
        {
            while (true)
            {
                foreach (Color col in cols)
                {
                    port.send(1, col.R);
                    port.send(2, col.G);
                    port.send(3, col.B);
                    port.send(5, col.A);
                    Thread.Sleep(200);
                }
            }
        }
        //Überbleibsel Ende.


        //Selbgeschriebene Funktion zur berechnung einer Differenz. Diese wird für Farbübergänge genutzt.
        public static float diff(float a, float b)
        {
            if (a < b)
                return b - a;
            if (a > b)
                return a - b;
            return 0;
        }

    }
}
